/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.impl.nodes;

import com.ibm.hwmca.fw.servlet.pmod.ModelContentHandler;
import com.ibm.hwmca.fw.servlet.pmod.PanelModelException;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.Node;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.Visitor;
import com.ibm.hwmca.fw.util.FastStack;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Properties;

public final class TextNode
extends Node {
    public static final String TRACE_MASK = "XPMNTXN";
    private char[][] buffers = new char[5][];
    private int[] starts = new int[5];
    private int[] lengths = new int[5];
    private int next = 0;

    public TextNode(Node parent, String prefix, String name, Properties attributes) {
        super(parent, prefix, name, attributes);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.getText());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.buffers = new char[5][];
        this.starts = new int[5];
        this.lengths = new int[5];
        this.next = 0;
        this.append((String)stream.readObject());
    }

    public void visit(Visitor visitor) throws PanelModelException {
        visitor.visit(this);
    }

    private void expand() {
        int newLength = this.buffers.length + 5;
        char[][] newBuffers = new char[newLength][];
        System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
        this.buffers = newBuffers;
        int[] newStarts = new int[newLength];
        System.arraycopy(this.starts, 0, newStarts, 0, this.starts.length);
        this.starts = newStarts;
        int[] newLengths = new int[newLength];
        System.arraycopy(this.lengths, 0, newLengths, 0, this.lengths.length);
        this.lengths = newLengths;
    }

    public void clear() {
        this.next = 0;
    }

    public void append(String string) {
        char[] data = string.toCharArray();
        this.append(data, 0, data.length);
    }

    public void append(char[] ch, int start, int length) {
        if (this.next >= this.buffers.length) {
            this.expand();
        }
        this.buffers[this.next] = ch;
        this.starts[this.next] = start;
        this.lengths[this.next++] = length;
    }

    public void append(char[] ch) {
        if (this.next >= this.buffers.length) {
            this.expand();
        }
        this.buffers[this.next] = ch;
        this.starts[this.next] = 0;
        this.lengths[this.next++] = ch.length;
    }

    public boolean isText() {
        return true;
    }

    public String getText() {
        StringBuffer sb = new StringBuffer(71);
        int i = 0;
        while (i < this.next) {
            sb.append(this.buffers[i], this.starts[i], this.lengths[i]);
            ++i;
        }
        return sb.toString();
    }

    protected void tagSpecificSerialize(ModelContentHandler handler, FastStack history, FastStack tryCatch) throws PanelModelException {
        int i = 0;
        while (i < this.next) {
            handler.characters(this.buffers[i], this.starts[i], this.lengths[i]);
            ++i;
        }
    }

    public String toString() {
        return super.toString() + this.getText();
    }
}

